/*
 * Decompiled with CFR 0.152.
 */
package ari.h2.astro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.h2.api.JavaObjectSerializer;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.io.BinaryCodec;
import org.locationtech.spatial4j.shape.Shape;

public class AstroH2ObjectSerializer
implements JavaObjectSerializer {
    private final SpatialContext ctx = SpatialContext.GEO;
    private final SpatialContextFactory ctxFactory = new SpatialContextFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(Object obj) throws Exception {
        if (obj == null) {
            return new byte[0];
        }
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            if (obj instanceof Shape) {
                Shape s = (Shape)obj;
                out.writeBoolean(true);
                new BinaryCodec(this.ctx, this.ctxFactory).writeShape((DataOutput)out, s);
            } else {
                out.writeBoolean(false);
                out.writeObject(obj);
            }
            out.flush();
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserialize(byte[] bytes) throws Exception {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);){
            ObjectInputStream in = new ObjectInputStream(byteIn);
            boolean isShape = in.readBoolean();
            if (isShape) {
                Shape shape = new BinaryCodec(this.ctx, this.ctxFactory).readShape((DataInput)in);
                return shape;
            }
            Object object = in.readObject();
            return object;
        }
    }
}

