/*
 * Decompiled with CFR 0.152.
 */
package adql.translator;

import adql.db.DBType;
import adql.db.STCS;
import adql.parser.ParseException;
import adql.query.IdentifierField;
import adql.query.operand.StringConstant;
import adql.query.operand.function.geometry.AreaFunction;
import adql.query.operand.function.geometry.BoxFunction;
import adql.query.operand.function.geometry.CentroidFunction;
import adql.query.operand.function.geometry.CircleFunction;
import adql.query.operand.function.geometry.ContainsFunction;
import adql.query.operand.function.geometry.DistanceFunction;
import adql.query.operand.function.geometry.ExtractCoord;
import adql.query.operand.function.geometry.ExtractCoordSys;
import adql.query.operand.function.geometry.IntersectsFunction;
import adql.query.operand.function.geometry.PointFunction;
import adql.query.operand.function.geometry.PolygonFunction;
import adql.query.operand.function.geometry.RegionFunction;
import adql.translator.JDBCTranslator;
import adql.translator.TranslationException;

public class H2Translator
extends JDBCTranslator {
    protected byte caseSensitivity = 0;

    public H2Translator() {
        this.caseSensitivity = (byte)15;
    }

    public H2Translator(boolean allCaseSensitive) {
        this.caseSensitivity = (byte)(allCaseSensitive ? 15 : 0);
    }

    public H2Translator(boolean catalog, boolean schema, boolean table, boolean column) {
        this.caseSensitivity = IdentifierField.CATALOG.setCaseSensitive(this.caseSensitivity, catalog);
        this.caseSensitivity = IdentifierField.SCHEMA.setCaseSensitive(this.caseSensitivity, schema);
        this.caseSensitivity = IdentifierField.TABLE.setCaseSensitive(this.caseSensitivity, table);
        this.caseSensitivity = IdentifierField.COLUMN.setCaseSensitive(this.caseSensitivity, column);
    }

    public boolean isCaseSensitive(IdentifierField field) {
        return field == null ? false : field.isCaseSensitive(this.caseSensitivity);
    }

    public String translate(StringConstant strConst) throws TranslationException {
        if (strConst.getValue() != null && strConst.getValue().contains("\\")) {
            return "STRINGDECODE(" + strConst.getValue() + ")";
        }
        return super.translate(strConst);
    }

    public String translate(ExtractCoord arg0) throws TranslationException {
        throw new TranslationException("Geometrical functions not implemented!");
    }

    public String translate(ExtractCoordSys arg0) throws TranslationException {
        throw new TranslationException("Geometrical functions not implemented!");
    }

    public String translate(AreaFunction arg0) throws TranslationException {
        throw new TranslationException("Geometrical functions not implemented!");
    }

    public String translate(CentroidFunction arg0) throws TranslationException {
        throw new TranslationException("Geometrical functions not implemented!");
    }

    public String translate(DistanceFunction arg0) throws TranslationException {
        throw new TranslationException("Geometrical functions not implemented!");
    }

    public String translate(ContainsFunction arg0) throws TranslationException {
        throw new TranslationException("Geometrical functions not implemented!");
    }

    public String translate(IntersectsFunction arg0) throws TranslationException {
        throw new TranslationException("Geometrical functions not implemented!");
    }

    public String translate(PointFunction arg0) throws TranslationException {
        throw new TranslationException("Geometrical functions not implemented!");
    }

    public String translate(CircleFunction arg0) throws TranslationException {
        throw new TranslationException("Geometrical functions not implemented!");
    }

    public String translate(BoxFunction arg0) throws TranslationException {
        throw new TranslationException("Geometrical functions not implemented!");
    }

    public String translate(PolygonFunction arg0) throws TranslationException {
        throw new TranslationException("Geometrical functions not implemented!");
    }

    public String translate(RegionFunction arg0) throws TranslationException {
        throw new TranslationException("Geometrical functions not implemented!");
    }

    public DBType convertTypeFromDB(int dbmsType, String rawDbmsTypeName, String dbmsTypeName, String[] params) {
        if (dbmsTypeName == null || dbmsTypeName.trim().length() == 0) {
            return null;
        }
        dbmsTypeName = dbmsTypeName.toLowerCase();
        int lengthParam = -1;
        if (params != null && params.length > 0) {
            try {
                lengthParam = Integer.parseInt(params[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (dbmsTypeName.equals("smallint") || dbmsTypeName.equals("int2") || dbmsTypeName.equals("year")) {
            return new DBType(DBType.DBDatatype.SMALLINT);
        }
        if (dbmsTypeName.equals("int") || dbmsTypeName.equals("integer") || dbmsTypeName.equals("mediumint") || dbmsTypeName.equals("int4") || dbmsTypeName.equals("signed")) {
            return new DBType(DBType.DBDatatype.INTEGER);
        }
        if (dbmsTypeName.equals("bigint") || dbmsTypeName.equals("int8")) {
            return new DBType(DBType.DBDatatype.BIGINT);
        }
        if (dbmsTypeName.equals("real") || dbmsTypeName.equals("float4")) {
            return new DBType(DBType.DBDatatype.REAL);
        }
        if (dbmsTypeName.equals("double") || dbmsTypeName.equals("double precision") || dbmsTypeName.equals("float") || dbmsTypeName.equals("float8")) {
            return new DBType(DBType.DBDatatype.DOUBLE);
        }
        if (dbmsTypeName.equals("binary")) {
            return new DBType(DBType.DBDatatype.BINARY, lengthParam);
        }
        if (dbmsTypeName.equals("varbinary") || dbmsTypeName.equals("longvarbinary") || dbmsTypeName.equals("raw") || dbmsTypeName.equals("bytea")) {
            return new DBType(DBType.DBDatatype.VARBINARY, lengthParam);
        }
        if (dbmsTypeName.equals("char") || dbmsTypeName.equals("character") || dbmsTypeName.equals("nchar")) {
            return new DBType(DBType.DBDatatype.CHAR, lengthParam);
        }
        if (dbmsTypeName.equals("varchar") || dbmsTypeName.equals("longvarchar") || dbmsTypeName.equals("varchar2") || dbmsTypeName.equals("nvarchar") || dbmsTypeName.equals("nvarchar2") || dbmsTypeName.equals("varchar_casesensitive") || dbmsTypeName.equals("varchar_ignorecase")) {
            return new DBType(DBType.DBDatatype.VARCHAR, lengthParam);
        }
        if (dbmsTypeName.equals("blob") || dbmsTypeName.equals("tinyblob") || dbmsTypeName.equals("mediumblob") || dbmsTypeName.equals("longblob") || dbmsTypeName.equals("image") || dbmsTypeName.equals("oid")) {
            return new DBType(DBType.DBDatatype.BLOB);
        }
        if (dbmsTypeName.equals("clob") || dbmsTypeName.equals("tinytext") || dbmsTypeName.equals("text") || dbmsTypeName.equals("mediumtext") || dbmsTypeName.equals("longtext") || dbmsTypeName.equals("ntext") || dbmsTypeName.equals("nclob")) {
            return new DBType(DBType.DBDatatype.CLOB);
        }
        if (dbmsTypeName.equals("timestamp") || dbmsTypeName.equals("datetime") || dbmsTypeName.equals("smalldatetime")) {
            return new DBType(DBType.DBDatatype.TIMESTAMP);
        }
        if (dbmsTypeName.equals("geometry")) {
            return new DBType(DBType.DBDatatype.REGION);
        }
        return null;
    }

    public String convertTypeToDB(DBType type) {
        if (type == null) {
            return "VARCHAR";
        }
        switch (type.type) {
            case SMALLINT: 
            case INTEGER: 
            case REAL: 
            case BIGINT: 
            case CHAR: 
            case VARCHAR: 
            case TIMESTAMP: 
            case DOUBLE: 
            case BINARY: 
            case VARBINARY: 
            case BLOB: 
            case CLOB: {
                return type.type.toString();
            }
        }
        return "GEOMETRY";
    }

    public STCS.Region translateGeometryFromDB(Object obj) throws ParseException {
        return null;
    }

    public Object translateGeometryToDB(STCS.Region region) throws ParseException {
        return null;
    }
}

