/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.chain;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Quadrant;
import com.vividsolutions.jts.index.chain.MonotoneChain;
import java.util.ArrayList;
import java.util.List;

public class MonotoneChainBuilder {
    public static int[] toIntArray(List list) {
        int[] array = new int[list.size()];
        int i = 0;
        while (i < array.length) {
            array[i] = (Integer)list.get(i);
            ++i;
        }
        return array;
    }

    public static List getChains(Coordinate[] pts) {
        return MonotoneChainBuilder.getChains(pts, null);
    }

    public static List getChains(Coordinate[] pts, Object context) {
        ArrayList<MonotoneChain> mcList = new ArrayList<MonotoneChain>();
        int[] startIndex = MonotoneChainBuilder.getChainStartIndices(pts);
        int i = 0;
        while (i < startIndex.length - 1) {
            MonotoneChain mc = new MonotoneChain(pts, startIndex[i], startIndex[i + 1], context);
            mcList.add(mc);
            ++i;
        }
        return mcList;
    }

    public static int[] getChainStartIndices(Coordinate[] pts) {
        int last;
        int start = 0;
        ArrayList<Integer> startIndexList = new ArrayList<Integer>();
        startIndexList.add(new Integer(start));
        do {
            last = MonotoneChainBuilder.findChainEnd(pts, start);
            startIndexList.add(new Integer(last));
        } while ((start = last) < pts.length - 1);
        int[] startIndex = MonotoneChainBuilder.toIntArray(startIndexList);
        return startIndex;
    }

    private static int findChainEnd(Coordinate[] pts, int start) {
        int safeStart = start;
        while (safeStart < pts.length - 1 && pts[safeStart].equals2D(pts[safeStart + 1])) {
            ++safeStart;
        }
        if (safeStart >= pts.length - 1) {
            return pts.length - 1;
        }
        int chainQuad = Quadrant.quadrant(pts[safeStart], pts[safeStart + 1]);
        int last = start + 1;
        while (last < pts.length) {
            int quad;
            if (!pts[last - 1].equals2D(pts[last]) && (quad = Quadrant.quadrant(pts[last - 1], pts[last])) != chainQuad) break;
            ++last;
        }
        return last - 1;
    }
}

