/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet.multipart;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;

public class PartInputStream
extends FilterInputStream {
    private String boundary;
    private byte[] buf = new byte[65536];
    private int count;
    private int pos;
    private boolean eof;

    PartInputStream(ServletInputStream in, String boundary) throws IOException {
        super((InputStream)in);
        this.boundary = boundary;
    }

    private void fill() throws IOException {
        if (this.eof) {
            return;
        }
        if (this.count > 0) {
            if (this.availableInBuffer() == 0) {
                System.arraycopy(this.buf, this.pos, this.buf, 0, this.count - this.pos);
                this.count -= this.pos;
                this.pos = 0;
            } else {
                throw new IllegalStateException("fill() detected illegal buffer state");
            }
        }
        int read = 0;
        int boundaryLength = this.boundary.length();
        int maxRead = this.buf.length - boundaryLength - 2;
        while (this.count < maxRead) {
            read = ((ServletInputStream)this.in).readLine(this.buf, this.count, this.buf.length - this.count);
            if (read == -1) {
                throw new IOException("unexpected end of part");
            }
            if (read >= boundaryLength) {
                this.eof = true;
                int i = 0;
                while (i < boundaryLength) {
                    if (this.boundary.charAt(i) != this.buf[this.count + i]) {
                        this.eof = false;
                        break;
                    }
                    ++i;
                }
                if (this.eof) break;
            }
            this.count += read;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.availableInBuffer() <= 0) {
            this.fill();
            if (this.availableInBuffer() <= 0) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int total = 0;
        if (len == 0) {
            return 0;
        }
        int avail = this.availableInBuffer();
        if (avail <= 0) {
            this.fill();
            avail = this.availableInBuffer();
            if (avail <= 0) {
                return -1;
            }
        }
        int copy = Math.min(len, avail);
        System.arraycopy(this.buf, this.pos, b, off, copy);
        this.pos += copy;
        total += copy;
        while (total < len) {
            this.fill();
            avail = this.availableInBuffer();
            if (avail <= 0) {
                return total;
            }
            copy = Math.min(len - total, avail);
            System.arraycopy(this.buf, this.pos, b, off + total, copy);
            this.pos += copy;
            total += copy;
        }
        return total;
    }

    private int availableInBuffer() {
        int avail = this.count - this.pos;
        int eol = 0;
        if (avail >= 2 && this.buf[this.count - 2] == 13) {
            eol = 2;
        } else if (avail >= 1 && this.buf[this.count - 1] == 10) {
            eol = 1;
        }
        return avail - eol;
    }

    @Override
    public int available() throws IOException {
        int avail = this.availableInBuffer() + this.in.available();
        return avail < 0 ? 0 : avail;
    }

    @Override
    public void close() throws IOException {
        if (!this.eof) {
            while (this.read(this.buf, 0, this.buf.length) != -1) {
            }
        }
    }
}

