/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape.jts;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.GeometricShapeFactory;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.spatial4j.context.jts.DatelineRule;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.context.jts.ValidationRule;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.locationtech.spatial4j.shape.impl.ShapeFactoryImpl;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;
import org.locationtech.spatial4j.shape.jts.JtsPoint;

public class JtsShapeFactory
extends ShapeFactoryImpl {
    protected static final LinearRing[] EMPTY_HOLES = new LinearRing[0];
    protected final GeometryFactory geometryFactory;
    protected final boolean allowMultiOverlap;
    protected final boolean useJtsPoint;
    protected final boolean useJtsLineString;
    protected final boolean useJtsMulti;
    protected final DatelineRule datelineRule;
    protected final ValidationRule validationRule;
    protected final boolean autoIndex;

    public JtsShapeFactory(JtsSpatialContext ctx, JtsSpatialContextFactory factory) {
        super(ctx, factory);
        this.geometryFactory = factory.getGeometryFactory();
        this.allowMultiOverlap = factory.allowMultiOverlap;
        this.useJtsPoint = factory.useJtsPoint;
        this.useJtsLineString = factory.useJtsLineString;
        this.useJtsMulti = factory.useJtsMulti;
        this.datelineRule = factory.datelineRule;
        this.validationRule = factory.validationRule;
        this.autoIndex = factory.autoIndex;
    }

    public boolean isAllowMultiOverlap() {
        return this.allowMultiOverlap;
    }

    public DatelineRule getDatelineRule() {
        return this.datelineRule;
    }

    public ValidationRule getValidationRule() {
        return this.validationRule;
    }

    public boolean isAutoIndex() {
        return this.autoIndex;
    }

    @Override
    public double normX(double x) {
        x = super.normX(x);
        return this.geometryFactory.getPrecisionModel().makePrecise(x);
    }

    @Override
    public double normY(double y) {
        y = super.normY(y);
        return this.geometryFactory.getPrecisionModel().makePrecise(y);
    }

    @Override
    public double normZ(double z) {
        z = super.normZ(z);
        return this.geometryFactory.getPrecisionModel().makePrecise(z);
    }

    @Override
    public double normDist(double d) {
        return this.geometryFactory.getPrecisionModel().makePrecise(d);
    }

    public Geometry getGeometryFrom(Shape shape) {
        if (shape instanceof JtsGeometry) {
            return ((JtsGeometry)shape).getGeom();
        }
        if (shape instanceof JtsPoint) {
            return ((JtsPoint)shape).getGeom();
        }
        if (shape instanceof Point) {
            Point point = (Point)shape;
            return this.geometryFactory.createPoint(new Coordinate(point.getX(), point.getY()));
        }
        if (shape instanceof Rectangle) {
            Rectangle r = (Rectangle)shape;
            if (r.getCrossesDateLine()) {
                ArrayList<Geometry> pair = new ArrayList<Geometry>(2);
                pair.add(this.geometryFactory.toGeometry(new Envelope(r.getMinX(), this.ctx.getWorldBounds().getMaxX(), r.getMinY(), r.getMaxY())));
                pair.add(this.geometryFactory.toGeometry(new Envelope(this.ctx.getWorldBounds().getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY())));
                return this.geometryFactory.buildGeometry(pair);
            }
            return this.geometryFactory.toGeometry(new Envelope(r.getMinX(), r.getMaxX(), r.getMinY(), r.getMaxY()));
        }
        if (shape instanceof Circle) {
            Circle circle = (Circle)shape;
            if (circle.getBoundingBox().getCrossesDateLine()) {
                throw new IllegalArgumentException("Doesn't support dateline cross yet: " + circle);
            }
            GeometricShapeFactory gsf = new GeometricShapeFactory(this.geometryFactory);
            gsf.setSize(circle.getBoundingBox().getWidth());
            gsf.setNumPoints(100);
            gsf.setCentre(new Coordinate(circle.getCenter().getX(), circle.getCenter().getY()));
            return gsf.createCircle();
        }
        throw new InvalidShapeException("can't make Geometry from: " + shape);
    }

    public boolean useJtsPoint() {
        return this.useJtsPoint;
    }

    @Override
    public Point pointXY(double x, double y) {
        return this.pointXYZ(x, y, Double.NaN);
    }

    @Override
    public Point pointXYZ(double x, double y, double z) {
        if (!this.useJtsPoint()) {
            return super.pointXY(x, y);
        }
        this.verifyX(x);
        this.verifyY(y);
        this.verifyZ(z);
        Coordinate coord = Double.isNaN(x) ? null : new Coordinate(x, y, z);
        return new JtsPoint(this.geometryFactory.createPoint(coord), (JtsSpatialContext)this.ctx);
    }

    public boolean useJtsLineString() {
        return this.useJtsLineString;
    }

    @Override
    public Shape lineString(List<Point> points, double bufferDistance) {
        if (!this.useJtsLineString()) {
            return super.lineString(points, bufferDistance);
        }
        Coordinate[] coords = new Coordinate[points.size()];
        for (int i = 0; i < coords.length; ++i) {
            Point p = points.get(i);
            if (p instanceof JtsPoint) {
                JtsPoint jtsPoint = (JtsPoint)p;
                coords[i] = jtsPoint.getGeom().getCoordinate();
                continue;
            }
            coords[i] = new Coordinate(p.getX(), p.getY());
        }
        JtsGeometry shape = this.makeShape((Geometry)this.geometryFactory.createLineString(coords));
        return bufferDistance != 0.0 ? shape.getBuffered(0.0, this.ctx) : shape;
    }

    @Override
    public ShapeFactory.LineStringBuilder lineString() {
        if (!this.useJtsLineString()) {
            return super.lineString();
        }
        return new JtsLineStringBuilder();
    }

    @Override
    public ShapeFactory.PolygonBuilder polygon() {
        return new JtsPolygonBuilder();
    }

    public boolean useJtsMulti() {
        return this.useJtsMulti;
    }

    @Override
    public ShapeFactory.MultiPointBuilder multiPoint() {
        if (!this.useJtsMulti) {
            return super.multiPoint();
        }
        return new JtsMultiPointBuilder();
    }

    @Override
    public ShapeFactory.MultiLineStringBuilder multiLineString() {
        if (!this.useJtsMulti) {
            return super.multiLineString();
        }
        return new JtsMultiLineStringBuilder();
    }

    @Override
    public ShapeFactory.MultiPolygonBuilder multiPolygon() {
        if (!this.useJtsMulti) {
            return super.multiPolygon();
        }
        return new JtsMultiPolygonBuilder();
    }

    @Override
    public <T extends Shape> ShapeFactory.MultiShapeBuilder<T> multiShape(Class<T> shapeClass) {
        if (!this.useJtsMulti()) {
            return super.multiShape(shapeClass);
        }
        return new JtsMultiShapeBuilder();
    }

    public Shape makeShapeFromGeometry(Geometry geom) {
        JtsGeometry jtsGeom;
        if (geom instanceof GeometryCollection) {
            if (!this.useJtsMulti || geom.getClass() == GeometryCollection.class) {
                ArrayList<Shape> shapes = new ArrayList<Shape>(geom.getNumGeometries());
                for (int i = 0; i < geom.getNumGeometries(); ++i) {
                    Geometry geomN = geom.getGeometryN(i);
                    shapes.add(this.makeShapeFromGeometry(geomN));
                }
                return ((ShapeFactoryImpl)this).multiShape(shapes);
            }
        } else {
            if (geom instanceof com.vividsolutions.jts.geom.Point) {
                com.vividsolutions.jts.geom.Point pt = (com.vividsolutions.jts.geom.Point)geom;
                return this.pointXY(pt.getX(), pt.getY());
            }
            if (geom instanceof LineString && !this.useJtsLineString()) {
                LineString lineString = (LineString)geom;
                ArrayList<Point> points = new ArrayList<Point>(lineString.getNumPoints());
                for (int i = 0; i < lineString.getNumPoints(); ++i) {
                    Coordinate coord = lineString.getCoordinateN(i);
                    points.add(this.pointXY(coord.x, coord.y));
                }
                return this.lineString(points, 0.0);
            }
        }
        try {
            jtsGeom = this.makeShape(geom);
            if (this.getValidationRule() != ValidationRule.none) {
                jtsGeom.validate();
            }
        }
        catch (RuntimeException e) {
            if (this.getValidationRule() == ValidationRule.repairConvexHull) {
                jtsGeom = this.makeShape(geom.convexHull());
            }
            if (this.getValidationRule() == ValidationRule.repairBuffer0) {
                jtsGeom = this.makeShape(geom.buffer(0.0));
            }
            throw e;
        }
        if (this.isAutoIndex()) {
            jtsGeom.index();
        }
        return jtsGeom;
    }

    public JtsGeometry makeShape(Geometry geom, boolean dateline180Check, boolean allowMultiOverlap) {
        return new JtsGeometry(geom, (JtsSpatialContext)this.ctx, dateline180Check, allowMultiOverlap);
    }

    public JtsGeometry makeShape(Geometry geom) {
        return this.makeShape(geom, this.datelineRule != DatelineRule.none, this.allowMultiOverlap);
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public Rectangle makeRectFromRectangularPoly(Geometry geom) {
        assert (geom.isRectangle());
        Envelope env = geom.getEnvelopeInternal();
        boolean crossesDateline = false;
        if (this.ctx.isGeo() && this.getDatelineRule() != DatelineRule.none) {
            if (this.getDatelineRule() == DatelineRule.ccwRect) {
                crossesDateline = !CGAlgorithms.isCCW((Coordinate[])geom.getCoordinates());
            } else {
                boolean bl = crossesDateline = env.getWidth() > 180.0;
            }
        }
        if (crossesDateline) {
            return this.rect(env.getMaxX(), env.getMinX(), env.getMinY(), env.getMaxY());
        }
        return this.rect(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY());
    }

    private class JtsMultiShapeBuilder<T extends Shape>
    extends ShapeFactoryImpl.GeneralShapeMultiShapeBuilder<T> {
        private JtsMultiShapeBuilder() {
        }

        @Override
        public Shape build() {
            Class<?> last = null;
            ArrayList<Object> geoms = new ArrayList<Object>(this.shapes.size());
            for (Shape s : this.shapes) {
                if (last != null && last != s.getClass()) {
                    return super.build();
                }
                if (s instanceof JtsGeometry) {
                    geoms.add(((JtsGeometry)s).getGeom());
                } else if (s instanceof JtsPoint) {
                    geoms.add(((JtsPoint)s).getGeom());
                } else {
                    return super.build();
                }
                last = s.getClass();
            }
            return JtsShapeFactory.this.makeShapeFromGeometry(JtsShapeFactory.this.geometryFactory.buildGeometry(geoms));
        }
    }

    private class JtsMultiPolygonBuilder
    implements ShapeFactory.MultiPolygonBuilder {
        List<Polygon> geoms = new ArrayList<Polygon>();

        private JtsMultiPolygonBuilder() {
        }

        @Override
        public ShapeFactory.PolygonBuilder polygon() {
            return new JtsPolygonBuilder();
        }

        @Override
        public ShapeFactory.MultiPolygonBuilder add(ShapeFactory.PolygonBuilder polygonBuilder) {
            this.geoms.add(((JtsPolygonBuilder)polygonBuilder).buildPolygonGeom());
            return this;
        }

        @Override
        public Shape build() {
            return JtsShapeFactory.this.makeShape((Geometry)JtsShapeFactory.this.geometryFactory.createMultiPolygon(this.geoms.toArray(new Polygon[this.geoms.size()])));
        }
    }

    private class JtsMultiLineStringBuilder
    implements ShapeFactory.MultiLineStringBuilder {
        List<LineString> geoms = new ArrayList<LineString>();

        private JtsMultiLineStringBuilder() {
        }

        @Override
        public ShapeFactory.LineStringBuilder lineString() {
            return new JtsLineStringBuilder();
        }

        @Override
        public ShapeFactory.MultiLineStringBuilder add(ShapeFactory.LineStringBuilder lineStringBuilder) {
            this.geoms.add(((JtsLineStringBuilder)lineStringBuilder).buildLineStringGeom());
            return this;
        }

        @Override
        public Shape build() {
            return JtsShapeFactory.this.makeShape((Geometry)JtsShapeFactory.this.geometryFactory.createMultiLineString(this.geoms.toArray(new LineString[this.geoms.size()])));
        }
    }

    private class JtsMultiPointBuilder
    extends CoordinatesAccumulator<JtsMultiPointBuilder>
    implements ShapeFactory.MultiPointBuilder {
        private JtsMultiPointBuilder() {
        }

        @Override
        public Shape build() {
            return JtsShapeFactory.this.makeShape((Geometry)JtsShapeFactory.this.geometryFactory.createMultiPoint(this.getCoordsArray()));
        }
    }

    private abstract class CoordinatesAccumulator<T extends CoordinatesAccumulator> {
        protected List<Coordinate> coordinates = new ArrayList<Coordinate>();

        private CoordinatesAccumulator() {
        }

        public T pointXY(double x, double y) {
            return this.pointXYZ(x, y, Double.NaN);
        }

        public T pointXYZ(double x, double y, double z) {
            JtsShapeFactory.this.verifyX(x);
            JtsShapeFactory.this.verifyY(y);
            this.coordinates.add(new Coordinate(x, y, z));
            return this.getThis();
        }

        protected Coordinate[] getCoordsArray() {
            return this.coordinates.toArray(new Coordinate[this.coordinates.size()]);
        }

        protected T getThis() {
            return (T)this;
        }
    }

    private class JtsPolygonBuilder
    extends CoordinatesAccumulator<JtsPolygonBuilder>
    implements ShapeFactory.PolygonBuilder {
        List<LinearRing> holes;

        private JtsPolygonBuilder() {
        }

        @Override
        public JtsHoleBuilder hole() {
            return new JtsHoleBuilder();
        }

        @Override
        public Shape build() {
            return JtsShapeFactory.this.makeShapeFromGeometry((Geometry)this.buildPolygonGeom());
        }

        @Override
        public Shape buildOrRect() {
            Polygon geom = this.buildPolygonGeom();
            if (geom.isRectangle()) {
                return JtsShapeFactory.this.makeRectFromRectangularPoly((Geometry)geom);
            }
            return JtsShapeFactory.this.makeShapeFromGeometry((Geometry)geom);
        }

        Polygon buildPolygonGeom() {
            LinearRing outerRing = JtsShapeFactory.this.geometryFactory.createLinearRing(this.getCoordsArray());
            LinearRing[] holeRings = this.holes == null ? EMPTY_HOLES : this.holes.toArray(new LinearRing[this.holes.size()]);
            return JtsShapeFactory.this.geometryFactory.createPolygon(outerRing, holeRings);
        }

        private class JtsHoleBuilder
        extends CoordinatesAccumulator<JtsHoleBuilder>
        implements ShapeFactory.PolygonBuilder.HoleBuilder {
            private JtsHoleBuilder() {
            }

            @Override
            public JtsPolygonBuilder endHole() {
                LinearRing linearRing = JtsShapeFactory.this.geometryFactory.createLinearRing(this.getCoordsArray());
                if (JtsPolygonBuilder.this.holes == null) {
                    JtsPolygonBuilder.this.holes = new ArrayList<LinearRing>(4);
                }
                JtsPolygonBuilder.this.holes.add(linearRing);
                return JtsPolygonBuilder.this;
            }
        }
    }

    private class JtsLineStringBuilder
    extends CoordinatesAccumulator<JtsLineStringBuilder>
    implements ShapeFactory.LineStringBuilder {
        protected double bufDistance;

        @Override
        public ShapeFactory.LineStringBuilder buffer(double distance) {
            this.bufDistance = distance;
            return this;
        }

        @Override
        public Shape build() {
            LineString geom = this.buildLineStringGeom();
            if (this.bufDistance != 0.0) {
                geom = geom.buffer(this.bufDistance);
            }
            return JtsShapeFactory.this.makeShape((Geometry)geom);
        }

        LineString buildLineStringGeom() {
            return JtsShapeFactory.this.geometryFactory.createLineString(this.getCoordsArray());
        }
    }
}

