/*
 * Decompiled with CFR 0.152.
 */
package ari.h2.astro;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.naming.OperationNotSupportedException;
import org.locationtech.spatial4j.SpatialPredicate;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.impl.CircleImpl;
import org.locationtech.spatial4j.shape.impl.PointImpl;
import org.locationtech.spatial4j.shape.impl.RectangleImpl;

public class AstroH2_old {
    private static final SpatialContext ctx = SpatialContext.GEO;

    public static final void main(String[] args) throws Throwable {
        if (args.length > 0 && args[0].equalsIgnoreCase("installation")) {
            for (Method m : AstroH2_old.class.getMethods()) {
                if (m.getName().equalsIgnoreCase("main") || m.getName().equalsIgnoreCase("toString") || !Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers())) continue;
                System.out.println("DROP ALIAS IF EXISTS " + m.getName().toUpperCase() + ";");
                System.out.println("CREATE ALIAS " + m.getName().toUpperCase() + " FOR \"" + AstroH2_old.class.getName() + "." + m.getName() + "\";");
            }
        } else {
            System.out.println("Spatial context: " + ctx);
            System.out.println(AstroH2_old.toString(AstroH2_old.point(45.0, 90.0)));
            System.out.println(AstroH2_old.area(AstroH2_old.point(45.0, 90.0)));
            System.out.println(AstroH2_old.toString(AstroH2_old.centroid(AstroH2_old.point(45.0, 90.0))));
            System.out.println(AstroH2_old.coord1(AstroH2_old.point(45.0, 90.0)));
            System.out.println(AstroH2_old.coord2(AstroH2_old.point(45.0, 90.0)));
            System.out.println();
            System.out.println(AstroH2_old.toString(AstroH2_old.circle(0.0, 90.0, 5.0)));
            System.out.println(AstroH2_old.area(AstroH2_old.circle(0.0, 90.0, 5.0)));
            System.out.println(AstroH2_old.toString(AstroH2_old.centroid(AstroH2_old.circle(0.0, 90.0, 5.0))));
            System.out.println();
            System.out.println(AstroH2_old.toString(AstroH2_old.box(0.0, 90.0, 5.0, 5.0)));
            System.out.println(AstroH2_old.area(AstroH2_old.box(0.0, 90.0, 5.0, 5.0)));
            System.out.println(AstroH2_old.toString(AstroH2_old.centroid(AstroH2_old.box(0.0, 90.0, 5.0, 5.0))));
            System.out.println();
            System.out.println(AstroH2_old.contains(AstroH2_old.point(25.0, -19.5), AstroH2_old.circle(25.4, -20.0, 1.0)));
            System.out.println(AstroH2_old.contains(AstroH2_old.point(-25.0, -19.5), AstroH2_old.circle(25.4, -20.0, 1.0)));
            System.out.println();
            System.out.println(AstroH2_old.intersects(AstroH2_old.circle(0.0, 0.0, 5.0), AstroH2_old.box(1.9, 1.9, 2.0, 2.0)));
            System.out.println(AstroH2_old.intersects(AstroH2_old.point(0.0, 0.0), AstroH2_old.circle(0.0, 0.0, 1.0)));
            System.out.println(AstroH2_old.intersects(AstroH2_old.point(0.0, 0.0), AstroH2_old.circle(5.0, 5.0, 1.0)));
            System.out.println();
            System.out.println(AstroH2_old.distance(AstroH2_old.point(0.0, 90.0), AstroH2_old.point(45.0, 90.0)));
            System.out.println(AstroH2_old.distance(AstroH2_old.point(0.0, 0.0), AstroH2_old.point(45.0, 0.0)));
        }
    }

    public static Object[] point(double ra, double dec) {
        return new Object[]{"POINT", ra, dec};
    }

    protected static Point createPoint(Object[] p) {
        return new PointImpl(((Number)p[1]).doubleValue() - 180.0, ((Number)p[2]).doubleValue(), ctx);
    }

    public static boolean isPoint(Object[] p) {
        return p != null && p.length == 3 && p[0].equals("POINT");
    }

    public static Object[] circle(double xCenter, double yCenter, double radius) throws IllegalArgumentException {
        if (radius < 0.0) {
            throw new IllegalArgumentException("Negative radius (here: " + radius + ") forbidden!");
        }
        if (radius > 180.0) {
            throw new IllegalArgumentException("Radius (here: " + radius + ") bigger than 180 forbidden!");
        }
        return new Object[]{"CIRCLE", xCenter, yCenter, radius};
    }

    protected static Circle createCircle(Object[] circle) {
        return new CircleImpl(AstroH2_old.createPoint(new Object[]{"POINT", circle[1], circle[2]}), ((Number)circle[3]).doubleValue(), ctx);
    }

    public static boolean isCircle(Object[] p) {
        return p != null && p.length == 4 && p[0].equals("CIRCLE");
    }

    public static Object[] box(double ra, double dec, double width, double height) throws IllegalArgumentException {
        if (width < 0.0 || width > 360.0) {
            throw new IllegalArgumentException("Incorrect box width: " + width + "! It should be a value between 0 and 360.");
        }
        if (height < 0.0 || height > 360.0) {
            throw new IllegalArgumentException("Incorrect box height: " + height + "! It should be a value between 0 and 360.");
        }
        return new Object[]{"BOX", ra, dec, width, height};
    }

    protected static Rectangle createBox(Object[] box) {
        return new RectangleImpl(((Number)box[1]).doubleValue() - ((Number)box[3]).doubleValue() / 2.0 - 180.0, ((Number)box[1]).doubleValue() + ((Number)box[3]).doubleValue() / 2.0 - 180.0, ((Number)box[2]).doubleValue() - ((Number)box[4]).doubleValue() / 2.0, ((Number)box[2]).doubleValue() + ((Number)box[4]).doubleValue() / 2.0, ctx);
    }

    public static boolean isBox(Object[] p) {
        return p != null && p.length == 5 && p[0].equals("BOX");
    }

    public static Object[] polygon(Object[] ... points) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Polygon are not yet supported by AstroH2! Sorry :(");
    }

    protected static Shape createPolygon(Object[] poly) {
        return null;
    }

    protected static Shape createShape(Object[] geom) throws ClassCastException, NullPointerException {
        if (geom == null) {
            return null;
        }
        if (AstroH2_old.isPoint(geom)) {
            return AstroH2_old.createPoint(geom);
        }
        if (AstroH2_old.isCircle(geom)) {
            return AstroH2_old.createCircle(geom);
        }
        if (AstroH2_old.isBox(geom)) {
            return AstroH2_old.createBox(geom);
        }
        return null;
    }

    public static double coord1(Object[] p) {
        try {
            return AstroH2_old.isPoint(p) ? ((Number)p[1]).doubleValue() : Double.NaN;
        }
        catch (ClassCastException cce) {
            return Double.NaN;
        }
    }

    public static double coord2(Object[] p) {
        try {
            return AstroH2_old.isPoint(p) ? ((Number)p[2]).doubleValue() : Double.NaN;
        }
        catch (ClassCastException cce) {
            return Double.NaN;
        }
    }

    public static String coordsys(Object[] geom) {
        return "";
    }

    public static double area(Object[] geom) {
        if (geom == null || geom.length == 0) {
            return Double.NaN;
        }
        try {
            return AstroH2_old.createShape(geom).getArea(ctx);
        }
        catch (Exception cce) {
            return Double.NaN;
        }
    }

    public static Object[] centroid(Object[] geom) {
        if (geom == null || geom.length == 0) {
            return null;
        }
        try {
            Object[] objectArray;
            Point center = AstroH2_old.createShape(geom).getCenter();
            if (center == null) {
                objectArray = null;
            } else {
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "POINT";
                objectArray2[1] = center.getX() + 180.0;
                objectArray = objectArray2;
                objectArray2[2] = center.getY();
            }
            return objectArray;
        }
        catch (Exception cce) {
            return null;
        }
    }

    public static double distance(Object[] p1, Object[] p2) {
        if (!AstroH2_old.isPoint(p1) || !AstroH2_old.isPoint(p2)) {
            return Double.NaN;
        }
        try {
            return DistanceUtils.distHaversineRAD((double)(((Number)p1[1]).doubleValue() * (Math.PI / 180)), (double)(((Number)p1[2]).doubleValue() * (Math.PI / 180)), (double)(((Number)p2[1]).doubleValue() * (Math.PI / 180)), (double)(((Number)p2[2]).doubleValue() * (Math.PI / 180))) * 57.29577951308232;
        }
        catch (Exception cce) {
            return Double.NaN;
        }
    }

    public static int contains(Object[] geom1, Object[] geom2) {
        try {
            return SpatialPredicate.Contains.evaluate(AstroH2_old.createShape(geom2), AstroH2_old.createShape(geom1)) ? 1 : 0;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static int intersects(Object[] geom1, Object[] geom2) {
        try {
            return SpatialPredicate.Intersects.evaluate(AstroH2_old.createShape(geom1), AstroH2_old.createShape(geom2)) ? 1 : 0;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static String toString(Object[] geom) {
        if (geom == null || geom.length == 0) {
            return "NULL";
        }
        StringBuffer buf = new StringBuffer();
        for (Object o : geom) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(o.toString());
        }
        return "[" + buf.toString() + "]";
    }
}

