/*
 * Decompiled with CFR 0.152.
 */
package ari.h2.astro;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.naming.OperationNotSupportedException;
import org.locationtech.spatial4j.SpatialPredicate;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.impl.CircleImpl;
import org.locationtech.spatial4j.shape.impl.PointImpl;
import org.locationtech.spatial4j.shape.impl.RectangleImpl;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class AstroH2 {
    private static final SpatialContext ctx = SpatialContext.GEO;

    public static final void main(String[] args) throws Throwable {
        if (args.length > 0 && args[0].equalsIgnoreCase("installation")) {
            for (Method m : AstroH2.class.getMethods()) {
                if (m.getName().equalsIgnoreCase("main") || m.getName().equalsIgnoreCase("toString") || !Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers())) continue;
                System.out.println("DROP ALIAS IF EXISTS " + m.getName().toUpperCase() + ";");
                System.out.println("CREATE ALIAS " + m.getName().toUpperCase() + " FOR \"" + AstroH2.class.getName() + "." + m.getName() + "\";");
            }
        } else {
            System.out.println("Spatial context: " + ctx);
            System.out.println(AstroH2.point(45.0, 90.0));
            System.out.println(AstroH2.area((Shape)AstroH2.point(45.0, 90.0)));
            System.out.println(AstroH2.centroid((Shape)AstroH2.point(45.0, 90.0)));
            System.out.println(AstroH2.coord1((Point)AstroH2.point(45.0, 90.0)));
            System.out.println(AstroH2.coord2((Point)AstroH2.point(45.0, 90.0)));
            System.out.println();
            System.out.println(AstroH2.circle(0.0, 90.0, 5.0));
            System.out.println(AstroH2.area((Shape)AstroH2.circle(0.0, 90.0, 5.0)));
            System.out.println(AstroH2.centroid((Shape)AstroH2.circle(0.0, 90.0, 5.0)));
            System.out.println();
            System.out.println(AstroH2.box(0.0, 90.0, 5.0, 5.0));
            System.out.println(AstroH2.area((Shape)AstroH2.box(0.0, 90.0, 5.0, 5.0)));
            System.out.println(AstroH2.centroid((Shape)AstroH2.box(0.0, 90.0, 5.0, 5.0)));
            System.out.println();
            System.out.println(AstroH2.contains((Shape)AstroH2.point(25.0, -19.5), (Shape)AstroH2.circle(25.4, -20.0, 1.0)));
            System.out.println(AstroH2.contains((Shape)AstroH2.point(-25.0, -19.5), (Shape)AstroH2.circle(25.4, -20.0, 1.0)));
            System.out.println();
            System.out.println(AstroH2.intersects((Shape)AstroH2.circle(0.0, 0.0, 5.0), (Shape)AstroH2.box(1.9, 1.9, 2.0, 2.0)));
            System.out.println(AstroH2.intersects((Shape)AstroH2.point(0.0, 0.0), (Shape)AstroH2.circle(0.0, 0.0, 1.0)));
            System.out.println(AstroH2.intersects((Shape)AstroH2.point(0.0, 0.0), (Shape)AstroH2.circle(5.0, 5.0, 1.0)));
            System.out.println();
            System.out.println(AstroH2.distance((Point)AstroH2.point(0.0, 90.0), (Point)AstroH2.point(45.0, 90.0)));
            System.out.println(AstroH2.distance((Point)AstroH2.point(0.0, 0.0), (Point)AstroH2.point(45.0, 0.0)));
        }
    }

    public static PointImpl point(double ra, double dec) {
        return new PointImpl(ra - 180.0, dec, ctx);
    }

    public static CircleImpl circle(double xCenter, double yCenter, double radius) throws IllegalArgumentException {
        if (radius < 0.0) {
            throw new IllegalArgumentException("Negative radius (here: " + radius + ") forbidden!");
        }
        if (radius > 180.0) {
            throw new IllegalArgumentException("Radius (here: " + radius + ") bigger than 180 forbidden!");
        }
        return new CircleImpl((Point)AstroH2.point(xCenter, yCenter), radius, ctx);
    }

    public static RectangleImpl box(double ra, double dec, double width, double height) throws IllegalArgumentException {
        if (width < 0.0 || width > 360.0) {
            throw new IllegalArgumentException("Incorrect box width: " + width + "! It should be a value between 0 and 360.");
        }
        if (height < 0.0 || height > 360.0) {
            throw new IllegalArgumentException("Incorrect box height: " + height + "! It should be a value between 0 and 360.");
        }
        return new RectangleImpl(ra - width / 2.0 - 180.0, ra + width / 2.0 - 180.0, dec - height / 2.0, dec + height / 2.0, ctx);
    }

    public static JtsGeometry polygon(Point ... points) throws OperationNotSupportedException {
        throw new OperationNotSupportedException("Polygon are not yet supported by AstroH2! Sorry :(");
    }

    public static double coord1(Point p) {
        return p == null ? Double.NaN : p.getX() + 180.0;
    }

    public static double coord2(Point p) {
        return p == null ? Double.NaN : p.getY();
    }

    public static String coordsys(Shape shp) {
        return "";
    }

    public static double area(Shape shp) {
        return shp == null ? Double.NaN : shp.getArea(ctx);
    }

    public static Point centroid(Shape shp) {
        return shp == null ? null : shp.getCenter();
    }

    public static double distance(Point p1, Point p2) {
        return p1 == null || p2 == null ? Double.NaN : ctx.calcDistance(p1, p2);
    }

    public static int contains(Shape geom1, Shape geom2) {
        return geom1 != null && geom2 != null && SpatialPredicate.Contains.evaluate(geom2, geom1) ? 1 : 0;
    }

    public static int intersects(Shape geom1, Shape geom2) {
        return geom1 != null && geom2 != null && SpatialPredicate.Intersects.evaluate(geom1, geom2) ? 1 : 0;
    }
}

