package it.inaf.ia2.vollt;

import java.sql.Statement;
import java.util.Arrays;
import org.junit.jupiter.api.Test;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

public class PrivateRowsQueryExecutorTest {

    @Test
    public void executeQueryTest() throws Exception {

        PrivateRowsQueryExecutor queryExecutor = new PrivateRowsQueryExecutor();

        CustomJobOwner user = new CustomJobOwner("user", Arrays.asList("group1", "group2"));

        Statement mockedStatement = mock(Statement.class);
        queryExecutor.executeQuery(mockedStatement, "", user);

        verify(mockedStatement).execute(eq("SET my.tap_groups = \"{group1,group2}\""));

        user = new CustomJobOwner("anonymous", Arrays.asList());
        queryExecutor.executeQuery(mockedStatement, "", user);

        verify(mockedStatement).execute(eq("SET my.tap_groups = \"{}\""));
    }
}
