package it.inaf.ia2.vollt;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.stream.Collectors;
import tap.db.QueryExecutor;
import uws.job.user.JobOwner;

public class PrivateRowsQueryExecutor extends QueryExecutor {

    @Override
    public ResultSet executeQuery(Statement statement, String sql, JobOwner jobOwner) throws SQLException {

        if (jobOwner instanceof CustomJobOwner) {
            CustomJobOwner user = (CustomJobOwner) jobOwner;
            statement.execute("SET my.tap_groups = \"{"
                    + String.join(",", user.getGroups().stream()
                            .map(g -> g.replace("'", "''"))
                            .collect(Collectors.toList()))
                    + "}\"");
        }

        return super.executeQuery(statement, sql, jobOwner);
    }
}
