package it.inaf.ia2.vollt;

import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import uws.UWSException;
import uws.job.user.JobOwner;
import uws.service.UWSUrl;
import uws.service.UserIdentifier;

public class CustomUserIdentifier implements UserIdentifier {

    @Override
    public JobOwner extractUserId(UWSUrl urlInterpreter, HttpServletRequest request) throws UWSException {

        String token = null;

        String header = request.getHeader("Authorization");
        if (header != null && !header.isEmpty()) {
            if (header.startsWith("Bearer ")) {
                token = header.substring("Bearer ".length());
            }
        }

        return getFakeUser(token);
    }

    @Override
    public JobOwner restoreUser(String id, String pseudo, Map<String, Object> otherData) throws UWSException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private CustomJobOwner getFakeUser(String token) {

        if (token != null) {
            switch (token) {
                case "token1":
                    return new CustomJobOwner("user1", Arrays.asList("group1", "group2"));
                case "token2":
                    return new CustomJobOwner("user2", Arrays.asList("group2"));
            }
        }

        return new CustomJobOwner("anonymous", Arrays.asList());
    }
}
