/*
 * This file is part of vospace-ui
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.vospace.ui.controller;

import it.inaf.ia2.vospace.ui.data.ShareRequest;
import it.inaf.ia2.vospace.ui.data.SharingInfo;
import it.inaf.ia2.vospace.ui.service.SharingService;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SharingController {

    @Autowired
    private SharingService sharingService;

    @GetMapping(value = "/sharing", produces = MediaType.APPLICATION_JSON_VALUE)
    public SharingInfo getSharingInfo() {
        return sharingService.getSharingInfo();
    }

    @PostMapping(value = "/sharing", consumes = MediaType.APPLICATION_JSON_VALUE, produces = MediaType.APPLICATION_JSON_VALUE)
    public ResponseEntity<?> setNodeGroups(@Valid @RequestBody ShareRequest shareRequest) {
        sharingService.setNodeGroups(shareRequest);
        return ResponseEntity.ok().build();
    }
}
