package it.inaf.ia2.vospace.ui.controller;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Scanner;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("${server.error.path:${error.path:/error}}")
public class ErrorController extends AbstractErrorController {

    @Value("${support.contact.label}")
    private String supportContactLabel;
    @Value("${support.contact.email}")
    private String supportContactEmail;

    @Autowired
    public ErrorController(ErrorAttributes errorAttributes) {
        super(errorAttributes);
    }

    @RequestMapping(produces = MediaType.TEXT_HTML_VALUE)
    public void errorHtml(HttpServletRequest request, HttpServletResponse response) throws Exception {

        Map<String, Object> errors = super.getErrorAttributes(request, true);

        HttpStatus status = getStatus(request);

        String responseText;
        if (status == HttpStatus.NOT_FOUND) {
            responseText = getFileContent("404.html");
        } else {
            responseText = getFileContent("error.html")
                    .replace("#ERROR_TITLE#", (String) errors.get("error"))
                    .replace("#ERROR_MESSAGE#", (String) errors.get("message"))
                    .replace("#ADDITIONAL_MESSAGE#", getAdditionalMessage(status));
        }

        response.setContentType("text/html;charset=UTF-8");
        response.getOutputStream().print(responseText);
    }

    private String getAdditionalMessage(HttpStatus status) {
        if (status.is5xxServerError()) {
            // unexpected error -> let users report the issue
            return "<br/>If you need support please contact"
                    + " <a href=\"mailto:" + supportContactEmail + "\">" + supportContactLabel + "</a>";
        }
        return "";
    }

    @RequestMapping
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        HttpStatus status = getStatus(request);
        if (status == HttpStatus.NO_CONTENT) {
            return new ResponseEntity<>(status);
        }
        Map<String, Object> body = getErrorAttributes(request, false);
        return new ResponseEntity<>(body, status);
    }

    private String getFileContent(String templateFileName) throws IOException {
        try (InputStream in = ErrorController.class.getClassLoader()
                .getResourceAsStream("public/error/" + templateFileName)) {
            Scanner s = new Scanner(in).useDelimiter("\\A");
            return s.hasNext() ? s.next() : "";
        }
    }

    @Override
    public String getErrorPath() {
        return null;
    }
}
