#!/usr/bin/env python
#
# This file is part of vospace-transfer-service
# Copyright (C) 2021 Istituto Nazionale di Astrofisica
# SPDX-License-Identifier: GPL-3.0-or-later
#

import time

from multiprocessing import Process

from config import Config
from job_queue import JobQueue


class TaskExecutor(Process):

    def __init__(self):
        config = Config("/etc/vos_ts/vos_ts.conf")
        params = config.loadSection("scheduling")
        self.maxPendingJobs = params.getint("max_pending_jobs")
        self.maxReadyJobs = params.getint("max_ready_jobs")
        self.maxTerminatedJobs = params.getint("max_terminated_jobs")
        self.maxCleanJobs = params.getint("max_clean_jobs")
        self.execWaitTime = params.getint("exec_wait_time")
        if self.execWaitTime < 5:
            self.execWaitTime = 5
        self.srcQueue = None
        self.destQueue = None
        super(TaskExecutor, self).__init__()

    def wait(self, delayTime = None):
        if delayTime is None:
            time.sleep(self.execWaitTime)
        else:
            time.sleep(delayTime)

    def setSourceQueueName(self, srcQueueName):
        self.srcQueue = JobQueue(srcQueueName)

    def setDestinationQueueName(self, destQueueName):
        self.destQueue = JobQueue(destQueueName)

    def run(self):
        """
        This method must be implemented by
        inherited classes
        """
        pass
