#!/usr/bin/env python
#
# This file is part of vospace-transfer-service
# Copyright (C) 2021 Istituto Nazionale di Astrofisica
# SPDX-License-Identifier: GPL-3.0-or-later
#

import time
import sys

from doi_executor import DOIExecutor
from doi_preprocessor import DOIPreprocessor
from group_rw_executor import GroupRwExecutor
from import_executor import ImportExecutor
from retrieve_preprocessor import RetrievePreprocessor
from store_preprocessor import StorePreprocessor
from retrieve_executor import RetrieveExecutor
from store_executor import StoreExecutor
from retrieve_cleaner import RetrieveCleaner


class JobScheduler(object):

    def __init__(self):
        self.taskExecutorList = []

    def addTaskExecutor(self, taskExecType):
        if taskExecType == "doi_preprocessor":
            self.taskExecutorList.append(DOIPreprocessor())
        elif taskExecType == "doi_executor":
            self.taskExecutorList.append(DOIExecutor())
        elif taskExecType == "group_rw_executor":
            self.taskExecutorList.append(GroupRwExecutor())
        elif taskExecType == "import_executor":
            self.taskExecutorList.append(ImportExecutor())
        elif taskExecType == "retrieve_preprocessor":
            self.taskExecutorList.append(RetrievePreprocessor())
        elif taskExecType == "store_preprocessor":
            self.taskExecutorList.append(StorePreprocessor())
        elif taskExecType == "retrieve_executor":
            self.taskExecutorList.append(RetrieveExecutor())
        elif taskExecType == "store_executor":
            self.taskExecutorList.append(StoreExecutor())
        elif taskExecType == "retrieve_cleaner":
            self.taskExecutorList.append(RetrieveCleaner())
        else:
            sys.exit(f"FATAL: unknown server type {taskExecType}.")

    def start(self):
        for taskExec in self.taskExecutorList:
            taskExec.start()
        running = False
        while not running:
            time.sleep(1)
            running = True
            for taskExec in self.taskExecutorList:
                running &= taskExec.is_alive()
