#!/usr/bin/env python
#
# This file is part of vospace-transfer-service
# Copyright (C) 2021 Istituto Nazionale di Astrofisica
# SPDX-License-Identifier: GPL-3.0-or-later
#

import json
import redis
import sys
import uuid

from redis.exceptions import ConnectionError


class RedisRPCClient(object):

    def __init__(self, host, port, db, rpcQueue):
        self.client = redis.Redis(host, port, db)
        self.rpcQueue = rpcQueue

    def call(self, request):
        requestId = uuid.uuid1().hex
        request["req_id"] = requestId
        try:
            self.client.lpush(self.rpcQueue, json.dumps(request))
            channel, response = self.client.brpop(requestId, timeout = 30)
        except ConnectionError:
            sys.exit("\nFATAL: unable to establish a connection with the message broker (Redis).\n")
        except TypeError:
            sys.exit("""\nFATAL: no response received.\n
Please check if the message broker (Redis) and the database (PostgreSQL) are up and running.\n""")
        else:
            response = json.loads(response.decode("utf-8"))
            return response


#client = RedisRPCClient("job_cache", "testList")
#client.call()
