/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.inaf.oats.vospace;

import it.inaf.oats.vospace.datamodel.NodeUtils;
import it.inaf.oats.vospace.exception.LinkFoundException;
import it.inaf.oats.vospace.exception.NodeNotFoundException;
import it.inaf.oats.vospace.exception.PermissionDeniedException;
import it.inaf.oats.vospace.persistence.NodeDAO;
import java.util.List;
import net.ivoa.xml.vospace.v2.Node;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.Isolation;
import it.inaf.ia2.aa.data.User;
import it.inaf.oats.vospace.exception.InternalFaultException;
import it.inaf.oats.vospace.exception.NodeBusyException;
import org.springframework.transaction.annotation.Transactional;

/**
 *
 * @author Nicola Fulvio Calabria <nicola.calabria at inaf.it>
 */
@Service
@EnableTransactionManagement
public class DeleteNodeService {

    @Autowired
    protected NodeDAO nodeDao;

    @Value("${vospace-authority}")
    protected String authority;

    @Transactional(rollbackFor = {Exception.class},
            isolation = Isolation.REPEATABLE_READ)
    public void deleteNode(String path, User principal) {

        Node toBeDeletedNode = nodeDao.listNode(path)
                .orElseThrow(() -> new NodeNotFoundException(path));

        if (!NodeUtils.checkIfWritable(toBeDeletedNode, principal.getName(), principal.getGroups())) {
            throw PermissionDeniedException.forPath(path);
        }

        Long nodeId = nodeDao.getNodeId(path).get();

        if (nodeDao.isBranchBusy(nodeId)) {
            throw new NodeBusyException(path);
        }

        if (nodeDao.isBranchImmutable(nodeId)) {
            throw new InternalFaultException("Target branch contains immutable nodes");
        }

        nodeDao.deleteNode(path);

    }

    public void doPreliminaryChecks(String path) {
        // Check if the node is present, 
        // if the node does not exist the service SHALL throw a HTTP 404 status code 
        // including a NodeNotFound fault in the entity-body 
        // If note present, got it
        nodeDao.listNode(path)
                .orElseThrow(() -> new NodeNotFoundException(path));

        // If a parent node in the URI path is a LinkNode, the service SHALL throw 
        // a HTTP 400 status code including a LinkFound fault in the entity-body.
        // For example, given the URI path /a/b/c, the service must throw a HTTP 400 
        // status code including a LinkFound fault in the entity-body if either /a 
        // or /a/b are LinkNodes.        
        if (path.equals("/")) {
            
            // Manage root node
            throw PermissionDeniedException.forPath("/");

        } else {
            List<String> pathComponents = NodeUtils.subPathComponents(path);

            // Manage all precursors in full path
            for (int i = 0; i < pathComponents.size(); i++) {
                String tmpPath = pathComponents.get(i);
                Node mynode = nodeDao.listNode(tmpPath)
                        .orElseThrow(() -> new NodeNotFoundException(tmpPath));
                if (mynode.getType().equals("vos:LinkNode") && i < pathComponents.size() - 1) // a LinkNode leaf can be deleted
                {
                    throw new LinkFoundException(tmpPath);
                }

            }

        }
    }
}
