/*
 * This file is part of vospace-rest
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.persistence;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Repository
public class LinkedServiceDAO {

    private static final Logger LOG = LoggerFactory.getLogger(LinkedServiceDAO.class);

    private static final ObjectMapper MAPPER = new ObjectMapper();

    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public LinkedServiceDAO(DataSource dataSource) {
        jdbcTemplate = new JdbcTemplate(dataSource);
    }

    boolean isLinkedServiceUrl(String targetUrl) {
        String sql = " SELECT COUNT(*) > 0\n"
                + "FROM linked_service\n"
                + "WHERE ? LIKE service_base_url || '%'";
        
        return jdbcTemplate.query(sql, ps -> {
            ps.setString(1, targetUrl);
        }, row -> {
            if (!row.next()) {
                throw new IllegalStateException("Expected one result");
            }
            return row.getBoolean(1);
        });
    }
}
