/*
 * This file is part of vospace-rest
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace;

import it.inaf.ia2.aa.data.User;
import net.ivoa.xml.vospace.v2.LinkNode;
import net.ivoa.xml.vospace.v2.Node;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PutMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RestController
public class CreateNodeController extends BaseNodeController {

    private static final Logger LOG = LoggerFactory.getLogger(CreateNodeController.class);

    @Autowired
    private CreateNodeService createNodeService;

    @PutMapping(value = {"/nodes", "/nodes/**"},
            consumes = {MediaType.APPLICATION_XML_VALUE, MediaType.TEXT_XML_VALUE, MediaType.APPLICATION_JSON_VALUE},
            produces = {MediaType.APPLICATION_XML_VALUE, MediaType.TEXT_XML_VALUE, MediaType.APPLICATION_JSON_VALUE})
    public Node createNode(@RequestBody Node node, User principal) {

        String path = getPath();

        LOG.debug("createNodeController called for node with URI {} and PATH {}", node.getUri(), path);
        this.validateAndCheckPayloadURIConsistence(node);

        // validate format of input node
        this.validateInputNode(node);

        return createNodeService.createNode(node, path, principal);

    }

    private void validateInputNode(Node node) {

        if (node instanceof LinkNode) {
            this.validateInternalLinkNode((LinkNode) node);
        }

    }

}
