/*
 * This file is part of vospace-rest
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace;

import it.inaf.oats.vospace.exception.InternalFaultException;
import it.inaf.oats.vospace.exception.NodeBusyException;
import it.inaf.oats.vospace.exception.PermissionDeniedException;
import it.inaf.oats.vospace.persistence.NodeDAO;
import it.inaf.oats.vospace.persistence.NodeDAO.ShortNodeDescriptor;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractNodeService {
    
    @Autowired
    protected NodeDAO nodeDao;

    @Value("${vospace-authority}")
    protected String authority;

    protected void validatePath(String path) {
        if (path.equals("/")) {
            throw new IllegalArgumentException("Cannot move root node or to root node");
        }
    }

    protected void validateDestinationContainer(ShortNodeDescriptor snd, String destinationVosPath) {
        if (snd.isBusy()) {
            throw new NodeBusyException(destinationVosPath);
        }
        if (snd.isPermissionDenied()) {
            throw new PermissionDeniedException(destinationVosPath);
        }
        if (!snd.isWritable()) {
            throw new InternalFaultException("Destination is not writable: " + destinationVosPath);
        }
        if (!snd.isContainer()) {
            throw new InternalFaultException("Existing destination is not a container: " + destinationVosPath);
        }

    }
}
