package it.inaf.oats.vospace.exception;

import net.ivoa.xml.uws.v1.ErrorSummaryFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.CONFLICT)
public class DuplicateNodeException extends VoSpaceErrorSummarizableException {

    public DuplicateNodeException(String path) {
        super("Duplicate Node at path: " + path,
                ErrorSummaryFactory.VOSpaceFault.DUPLICATE_NODE);
    }
}
