/*
 * This file is part of vospace-rest
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.exception;

// NFC: ErrorType usage is not covered in documentation, as far as I can see
// these are tentative default values.
import net.ivoa.xml.uws.v1.ErrorType;

public enum VOSpaceFaultEnum {
    // pushto
    OPERATION_NOT_SUPPORTED("Operation Not Supported", ErrorType.FATAL, "OperationNotSupported"),
    INTERNAL_FAULT("Internal Fault", ErrorType.TRANSIENT, "InternalFault"),
    PERMISSION_DENIED("Permission Denied", ErrorType.FATAL, "PermissionDenied"),
    VIEW_NOT_SUPPORTED("View Not Supported", ErrorType.FATAL, "ViewNotSupported"),
    PROTOCOL_NOT_SUPPORTED("Protocol Not Supported", ErrorType.FATAL, "ProtocolNotSupported"),
    INVALID_ARGUMENT("Invalid Argument", ErrorType.FATAL, "InvalidArgument"),
    NODE_BUSY("Node Busy", ErrorType.TRANSIENT, "NodeBusy"),
    // additional for pullto
    INVALID_URI("Invalid URI", ErrorType.FATAL, "InvalidURI"),
    INVALID_DATA("Invalid Data", ErrorType.FATAL, "InvalidData"),
    // additional for pullfrom
    NODE_NOT_FOUND("Node Not Found", ErrorType.FATAL, "NodeNotFound"),
    // additional for pushfrom
    TRANSFER_FAILED("Transfer Failed", ErrorType.FATAL, "TransferFailed"),
    // additional for movenode/copynode
    DUPLICATE_NODE("Duplicate Node", ErrorType.FATAL, "DuplicateNode"),
    QUOTA_EXCEEDED("Quota Exceeded", ErrorType.FATAL, "QuotaExceeded");

    private final String faultRepresentation;
    private final ErrorType type;
    private final String faultCaptionForDetails;

    private VOSpaceFaultEnum(String faultRepresentation,
            ErrorType type,
            String faultCaptionForDetails) {
        this.faultRepresentation = faultRepresentation;
        this.type = type;
        this.faultCaptionForDetails = faultCaptionForDetails;
    }

    public String getFaultRepresentation() {
        return this.faultRepresentation;
    }

    public ErrorType getType() {
        return this.type;
    }

    public String getFaultCaptionForDetails() {
        return faultCaptionForDetails;
    }

}
