/*
 * This file is part of vospace-parent-classes
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.exception;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(HttpStatus.INSUFFICIENT_STORAGE)
public class QuotaExceededException extends VoSpaceErrorSummarizableException {

    public QuotaExceededException(String errorDetail) {
        super(errorDetail, VOSpaceFaultEnum.QUOTA_EXCEEDED);
    }
}
