/*
 * This file is part of vospace-rest
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.parent.exchange;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.Transient;

public class ArchiveEntryDescriptor {

    private final String vosPath;
    private final String targetNodeVosPath;

    @JsonCreator
    public ArchiveEntryDescriptor(@JsonProperty("vosPath")String vosPath, 
            @JsonProperty("targetNodeVosPath") String targetNodeVosPath) {
        this.vosPath = vosPath;
        this.targetNodeVosPath = targetNodeVosPath;
    }

    public ArchiveEntryDescriptor(String vosPath) {
        this(vosPath, vosPath);
    }

    public String getVosPath() {
        return vosPath;
    }

    public String getTargetNodeVosPath() {
        return targetNodeVosPath;
    }

    @Transient
    public boolean isPointingToAnotherNode() {
        return !targetNodeVosPath.equals(vosPath);
    }

}
