/*
 * This file is part of vospace-rest
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.exception;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.BAD_REQUEST)
public class ProtocolNotSupportedException extends VoSpaceErrorSummarizableException{
    
    public ProtocolNotSupportedException(String protocol) {
        super("Protocol: " + protocol, 
                VOSpaceFaultEnum.PROTOCOL_NOT_SUPPORTED);
    }
    
}
