package it.inaf.oats.vospace.exception;

import net.ivoa.xml.uws.v1.ErrorSummaryFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.BAD_REQUEST)
public class InvalidURIException extends VoSpaceErrorSummarizableException {

    public InvalidURIException(String URI, String path) {
        super("InvalidURI. Payload node URI: " + URI
                + " is not consistent with request path: " + path,
                ErrorSummaryFactory.VOSpaceFault.INVALID_URI);
    }

    public InvalidURIException(String URI) {
        super("InvalidURI. URI: " + URI + " is not in a valid format",
                ErrorSummaryFactory.VOSpaceFault.INVALID_URI);
    }

    public InvalidURIException(IllegalArgumentException ex) {
        super("InvalidURI. " + ex.getMessage(),
                ErrorSummaryFactory.VOSpaceFault.INVALID_URI);
    }
}
