package it.inaf.oats.vospace.exception;

import net.ivoa.xml.uws.v1.ErrorSummaryFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.NOT_FOUND)
public class ContainerNotFoundException extends VoSpaceErrorSummarizableException {

    public ContainerNotFoundException(String path) {
        super("Container Not Found at path: " + path, 
                ErrorSummaryFactory.VOSpaceFault.NODE_NOT_FOUND);
    }
}
