/*
 * This file is part of vospace-rest
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.parent.exchange;

public class ArchiveEntryDescriptor {

    private final String vosPath;
    private final String targetNodeVosPath;

    public ArchiveEntryDescriptor(String vosPath, String targetNodeVosPath) {
        this.vosPath = vosPath;
        this.targetNodeVosPath = targetNodeVosPath;
    }

    public ArchiveEntryDescriptor(String vosPath) {
        this(vosPath, null);
    }

    public String getVosPath() {
        return vosPath;
    }

    public String getTargetNodeVosPath() {
        if (targetNodeVosPath == null) {
            return vosPath;
        } else {
            return targetNodeVosPath;
        }
    }
    
    public boolean isPointingToAnotherNode() {
        return (targetNodeVosPath != null && 
                !targetNodeVosPath.equals(vosPath));
    }

}
