/*
 * This file is part of vospace-parent-classes
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.exception;

import net.ivoa.xml.uws.v1.ErrorSummary;

public class ErrorSummaryFactory {    

    public static ErrorSummary newErrorSummary(VOSpaceFaultEnum error, String detailMessage) {
        ErrorSummary result = new ErrorSummary();
        result.setMessage(error.getFaultRepresentation());
        result.setType(error.getType());

        if (detailMessage == null || detailMessage.isBlank()) {
            result.setHasDetail(false);
        } else {
            result.setHasDetail(true);
            result.setDetailMessage(error.getFaultCaptionForDetails()
                    + " "
                    + detailMessage);
        }

        return result;
    }

    public static ErrorSummary newErrorSummary(VOSpaceFaultEnum error) {
        return newErrorSummary(error, null);
    }
    
    public static ErrorSummary newErrorSummary(VoSpaceErrorSummarizableException e)
    {
        return newErrorSummary(e.getFault(), e.getDetailMessage());
    }
}
