/*
 * This file is part of vospace-parent-classes
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.exception;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.CONFLICT)
public class DuplicateNodeException extends VoSpaceErrorSummarizableException {

    public DuplicateNodeException(String path) {
        super("Path: " + path,
                VOSpaceFaultEnum.DUPLICATE_NODE);
    }
}
