/*
 * This file is part of vospace-parent-classes
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.exception;

import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value = HttpStatus.FORBIDDEN)
public class PermissionDeniedException extends VoSpaceErrorSummarizableException {

    public PermissionDeniedException(String errorDetail) {
        super(errorDetail, VOSpaceFaultEnum.PERMISSION_DENIED);
    }

    public static PermissionDeniedException forPath(String path) {
        return new PermissionDeniedException("Path: " + path);
    }
}
