/*
 * This file is part of vospace-file-service
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.transfer.service;

import it.inaf.ia2.transfer.auth.TokenPrincipal;
import it.inaf.oats.vospace.parent.exchange.ArchiveEntryDescriptor;
import java.util.List;

public class ArchiveJob {

    public static enum Type {
        TAR,
        ZIP;

        public String getExtension() {
            switch (this) {
                case TAR:
                    return "tar";
                case ZIP:
                    return "zip";
                default:
                    throw new IllegalArgumentException("Extension not defined for type " + this);
            }
        }
    }

    private List<ArchiveEntryDescriptor> entryDescriptors;
    private TokenPrincipal tokenPrincipal;
    private String jobId;
    private Type type;

    public List<ArchiveEntryDescriptor> getEntryDescriptors() {
        return entryDescriptors;
    }

    public void setEntryDescriptors(List<ArchiveEntryDescriptor> entryDescriptors) {
        this.entryDescriptors = entryDescriptors;
    }

    public TokenPrincipal getPrincipal() {
        return tokenPrincipal;
    }

    public void setPrincipal(TokenPrincipal tokenPrincipal) {
        this.tokenPrincipal = tokenPrincipal;
    }

    public String getJobId() {
        return jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

}
