/*
 * This file is part of vospace-file-service
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.transfer.service;

import it.inaf.ia2.transfer.auth.GmsClient;
import it.inaf.ia2.transfer.auth.TokenPrincipal;
import it.inaf.ia2.transfer.persistence.model.FileInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthorizationService {

    @Autowired
    private GmsClient gmsClient;

    public boolean isDownloadable(FileInfo fileInfo, TokenPrincipal principal) {

        if (fileInfo.isPublic()) {
            return true;
        }

        String token = principal.getToken();
        if (token == null) {
            return false;
        }

        if (principal.getName().equals(fileInfo.getOwnerId())) {
            return true;
        }

        // TODO: configure cache
        if (fileInfo.getGroupRead() == null) {
            return false;
        }
        for (String group : fileInfo.getGroupRead()) {
            if (gmsClient.isMemberOf(token, group)) {
                return true;
            }
        }
        return false;
    }
}
