/*
 * This file is part of vospace-file-service
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.transfer;

import it.inaf.ia2.aa.jwt.JwksClient;
import it.inaf.ia2.aa.jwt.TokenParser;
import it.inaf.ia2.transfer.auth.TokenFilter;
import java.net.URI;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestTemplate;
import org.springframework.context.annotation.Import;
import it.inaf.oats.vospace.parent.persistence.LinkedServiceDAO;
import it.inaf.ia2.aa.ServiceLocator;
import it.inaf.ia2.aa.ServletRapClient;

@SpringBootApplication
@Import(LinkedServiceDAO.class)
public class FileServiceApplication {

    @Value("${jwks_uri}")
    private String jwksUri;

    public static void main(String[] args) {
        SpringApplication.run(FileServiceApplication.class, args);
    }

    @Bean
    public TokenParser tokenParser() {
        JwksClient jwksClient = new JwksClient(URI.create(jwksUri));
        return new TokenParser(jwksClient);
    }

    @Bean
    public FilterRegistrationBean tokenFilterRegistration(TokenParser tokenParser) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter(new TokenFilter(tokenParser));
        registration.addUrlPatterns("/*");
        return registration;
    }
    
    @Bean
    public ServletRapClient servletRapClient() {
        return (ServletRapClient) ServiceLocator.getInstance().getRapClient();
    }

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }
}
