/*
 * This file is part of vospace-file-service
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.transfer.persistence;

import java.util.Map;
import javax.sql.DataSource;
import static org.junit.jupiter.api.Assertions.assertEquals;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(SpringExtension.class)
@ContextConfiguration(classes = {DataSourceConfig.class})
@TestPropertySource(locations = "classpath:test.properties")
public class LocationDAOTest {

    @Autowired
    private DataSource dataSource;

    private LocationDAO dao;

    @BeforeEach
    public void init() {
        dao = new LocationDAO(dataSource);
    }

    @Test
    public void testGetPortalLocationUrls() {
        Map<Integer, String> map = dao.getPortalLocationUrls();

        assertEquals(1, map.size());
        assertEquals("http://archive.lbto.org/files/lbt", map.get(4));
    }
}
