/*
 * This file is part of vospace-file-service
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.transfer.auth;

import static org.junit.jupiter.api.Assertions.assertFalse;
import static org.junit.jupiter.api.Assertions.assertTrue;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.eq;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

@ExtendWith(MockitoExtension.class)
public class GmsClientTest {

    @Mock
    private RestTemplate restTemplate;

    @InjectMocks
    private GmsClient gmsClient;

    @Test
    public void testIsMemberOf() {
        mockGmsResponse("group1\n");
        assertTrue(gmsClient.isMemberOf("<token>", "group1"));
    }

    @Test
    public void testIsNotMemberOf() {
        mockGmsResponse("");
        assertFalse(gmsClient.isMemberOf("<token>", "group1"));
    }

    private void mockGmsResponse(String body) {

        ResponseEntity<String> mockedResponse = mock(ResponseEntity.class);
        when(mockedResponse.getBody()).thenReturn(body);

        when(restTemplate.exchange(any(String.class), eq(HttpMethod.GET), any(HttpEntity.class), eq(String.class))).thenReturn(mockedResponse);
    }
}
