/*
 * This file is part of vospace-file-service
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.transfer.persistence;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class LocationDAO {

    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public LocationDAO(DataSource fileCatalogDatasource) {
        this.jdbcTemplate = new JdbcTemplate(fileCatalogDatasource);
    }

    public Map<Integer, String> getPortalLocationUrls() {

        String sql = "SELECT location_id, hostname, base_url\n"
                + "FROM location l\n"
                + "JOIN storage s ON s.storage_id = l.storage_dest_id\n"
                + "WHERE location_type = 'portal'";

        return jdbcTemplate.query(sql, rs -> {
            Map<Integer, String> locationUrls = new HashMap<>();
            while (rs.next()) {
                int locationId = rs.getInt("location_id");
                String hostname = rs.getString("hostname");
                String baseUrl = rs.getString("base_url");
                String url = "http://" + hostname + baseUrl;
                locationUrls.put(locationId, url);
            }
            return locationUrls;
        });
    }
}
