/*
 * This file is part of vospace-file-service
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.ia2.transfer.auth;

import java.security.Principal;

public class TokenPrincipal implements Principal {

    private final String name;
    private final String token;

    public TokenPrincipal() {
        this("anonymous", null);
    }

    public TokenPrincipal(String userId, String token) {
        this.name = userId;
        this.token = token;
    }

    @Override
    public String getName() {
        return name;
    }

    public String getToken() {
        return token;
    }
}
