/*
 * This file is part of vospace-datamodel
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.datamodel.collections;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

/**
 *
 * @author Nicola Fulvio Calabria <nicola.calabria at inaf.it>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "node-details")
public class NodeDetails {

    @XmlAttribute(name = "node-id", required = true)
    private Long nodeId;

    @XmlAttribute(name = "node-vos-path", required = true)
    private String nodeVosPath;

    public NodeDetails() {
        // no op       
    }

    public Long getNodeId() {
        return nodeId;
    }

    public void setNodeId(Long nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeVosPath() {
        return nodeVosPath;
    }

    public void setNodeVosPath(String nodeVosPath) {
        this.nodeVosPath = nodeVosPath;
    }

}
