/*
 * This file is part of vospace-datamodel
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.datamodel.collections;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Wrapper class for REST GET
 *
 * @author Nicola Fulvio Calabria <nicola.calabria at inaf.it>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "node-collections-wrapper")
public class NodeCollectionsWrapper {

    @XmlElementWrapper(name = "node-collections-list", required = true)
    @XmlElement(name = "node-collection")
    private List<NodeCollection> nodeCollections;

    public NodeCollectionsWrapper() {
        this.nodeCollections = new ArrayList<>();
    }

    public List<NodeCollection> getNodeCollections() {
        return nodeCollections;
    }

    public void setNodeCollections(List<NodeCollection> nodeCollections) {
        this.nodeCollections = nodeCollections;
    }

}
