/*
 * This file is part of vospace-datamodel
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */
package it.inaf.oats.vospace.datamodel.collections;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

/**
 *
 * @author Nicola Fulvio Calabria <nicola.calabria at inaf.it>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "node-collection")
public class NodeCollection {
    
    @XmlAttribute(name = "id", required = true)
    private Long id;
    
    @XmlAttribute(name = "title", required = true)
    private String title;
    
    @XmlAttribute(name = "owner-id", required = true)
    private String ownerId;
    
    public NodeCollection() {
        // no op
    }
        
    public NodeCollection(Long id, String title, String ownerId) {
        this.id = id;
        this.title = title;
        this.ownerId = ownerId;
    }    

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }    
    
    
}
