package it.inaf.oats.vospace.datamodel;

import com.fasterxml.jackson.databind.util.StdConverter;
import net.ivoa.xml.vospace.v2.Node;

/**
 * Fills the type field at the end of the JSON deserialization.
 * Node implementations must be annotated with
 * @JsonDeserialize(converter = NodeTypeAdder.<NodeType>.class)
 */
public class NodeTypeSetter<T extends Node> extends StdConverter<T, T> {

    @Override
    public T convert(T node) {
        node.setType("vos:" + node.getClass().getSimpleName());
        return node;
    }

    public static class UnstructuredDataNode extends NodeTypeSetter<net.ivoa.xml.vospace.v2.UnstructuredDataNode> {
    }

    public static class StructuredDataNode extends NodeTypeSetter<net.ivoa.xml.vospace.v2.StructuredDataNode> {
    }

    public static class ContainerNode extends NodeTypeSetter<net.ivoa.xml.vospace.v2.ContainerNode> {
    }

    public static class LinkNode extends NodeTypeSetter<net.ivoa.xml.vospace.v2.LinkNode> {
    }
}
