package it.inaf.oats.vospace.datamodel;

import java.util.ArrayList;
import java.util.List;
import static org.junit.jupiter.api.Assertions.assertArrayEquals;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;
import org.junit.jupiter.api.Test;

public class NodeUtilsTest {

    @Test
    public void testGetPathFromRequestURLString() {

        String requestUrl = "http://localhost/vospace/nodes/a/b/c/";
        assertEquals("/a/b/c", NodeUtils.getPathFromRequestURLString(requestUrl));
    }

    @Test
    public void testGetPathWithSpacesFromRequestURLString() {

        String requestUrl = "http://localhost/vospace/nodes/a/b/c%20d%20%C3%A4+%2B.pdf";
        assertEquals("/a/b/c d ä +.pdf", NodeUtils.getPathFromRequestURLString(requestUrl));
    }

    @Test
    public void testEncodePathSpecialChars() {

        String specialChars = "ä è#+ /other/+-ò@";
        assertEquals("%C3%A4%20%C3%A8%23%2B%20/other/%2B-%C3%B2%40", NodeUtils.urlEncodePath(specialChars));
    }

    @Test
    public void testIllegalBrakets() {
        testIllegalChars("<no>.pdf");
    }

    @Test
    public void testIllegalQuestionMark() {
        testIllegalChars("???.pdf");
    }

    @Test
    public void testIllegalQuotes() {
        testIllegalChars("\"'.pdf");
    }
    
    @Test
    public void testIllegalSlashEncoded() {
        testIllegalChars("%2F.pdf");
    }

    private void testIllegalChars(String illegalString) {
        boolean exception = false;
        try {
            NodeUtils.getPathFromRequestURLString("http://localhost/vospace/nodes/path/to/" + illegalString);
        } catch (IllegalArgumentException ex) {
            exception = true;
        }
        assertTrue(exception);
    }

    //@Test
    public void getPathFromRequestURLStringTest() {
        
        
        String urlForTest = "http://server.example.com/vospace/";
        String result = NodeUtils.getPathFromRequestURLString(urlForTest);
        assertEquals("/", result);
        
        urlForTest = "http://server.example.com/vospace/nodes";
        result = NodeUtils.getPathFromRequestURLString(urlForTest);
        assertEquals("/", result);
        
        urlForTest = "http://server.example.com/vospace/nodes/mydata";
        result = NodeUtils.getPathFromRequestURLString(urlForTest);
        assertEquals("/mydata", result);
        
        urlForTest = "http://server.example.com/vospace/nodes/mydata1/uffi/nonso/pappa.txt";
        result = NodeUtils.getPathFromRequestURLString(urlForTest);
        assertEquals("/mydata1/uffi/nonso/pappa.txt", result);
    }
     
    /* Is it a possible case?
    @Test
    public void subPathComponentsTest1() {
        
        //assertArrayEquals(expected, actual)
        String pathForTest = "";
        List result = NodeUtils.subPathComponents(pathForTest);
        List expected = new ArrayList();     // expected empty
        assertArrayEquals(expected.toArray(), result.toArray());
        
    }
    */
        
    @Test
    public void subPathComponentsTest2() {
        
        String pathForTest = "/";
        List result = NodeUtils.subPathComponents(pathForTest);
        List expected = new ArrayList();
        expected.add("/");
        assertArrayEquals(expected.toArray(), result.toArray());
        
                
    }   
    
        
    @Test
    public void subPathComponentsTest3() {        
        
        String pathForTest = "/mynode1";
        List result = NodeUtils.subPathComponents(pathForTest);
        List expected = new ArrayList();
        expected.add("/mynode1");
        assertArrayEquals(expected.toArray(), result.toArray());
        
    }
    
        
    @Test
    public void subPathComponentsTest4() {
        
        //assertArrayEquals(expected, actual)
        String pathForTest = "/mydata1/uffi/nonso/pappa.txt";
        List result = NodeUtils.subPathComponents(pathForTest);
        List expected = new ArrayList();
        expected.add("/mydata1");
        expected.add("/mydata1/uffi");
        expected.add("/mydata1/uffi/nonso");
        expected.add("/mydata1/uffi/nonso/pappa.txt");
        assertArrayEquals(expected.toArray(), result.toArray());
        
    }
}
