package it.inaf.oats.vospace.datamodel;

import java.util.List;
import java.util.stream.Collectors;
import net.ivoa.xml.vospace.v2.Node;
import net.ivoa.xml.vospace.v2.Property;

public abstract class NodeProperties {
    
    
    private NodeProperties() { }
    
    public static final String BASE_URI = "ivo://ivoa.net/vospace/core#";
    public static final String AVAILABLE_SPACE_URI = "ivo://ivoa.net/vospace/core#availableSpace";      // the amount of space available within a container      
    public static final String INITIAL_CREATION_TIME_URI  = "ivo://ivoa.net/vospace/core#btime";       // the initial creation time
    public static final String CONTRIBUTOR_URI  = "ivo://ivoa.net/vospace/core#contributor"; // an entity responsible for making contributions to this resource
    public static final String COVERAGE_URI  = "ivo://ivoa.net/vospace/core#coverage";    // a spatial or temporal topic of the resource, the spatial applicability of the resource, or the jurisdiction under which the resource is relevant      
    public static final String CREATOR_URI  = "ivo://ivoa.net/vospace/core#creator";     // an entity primarily responsible for making the resource
    public static final String STATUS_CHANGE_TIME_URI  = "ivo://ivoa.net/vospace/core#ctime";       // the status change (aka metadata modification) time    
    public static final String DATE_URI  = "ivo://ivoa.net/vospace/core#date";        // a point or period of time associated with an event in the lifecycle of the resource
    public static final String DESCRIPTION_URI  = "ivo://ivoa.net/vospace/core#description"; // an account of the resource    
    public static final String FORMAT_URI  = "ivo://ivoa.net/vospace/core#format";      // the file format, physical medium or dimensions of the resource
    public static final String GROUP_READ_URI  = "ivo://ivoa.net/vospace/core#groupread";   // the list of groups which can only read this resource  delimiter-separated 
    public static final String GROUP_WRITE_URI  = "ivo://ivoa.net/vospace/core#groupwrite";  // the list of groups which can read and write to this resource  delimiter-separated 
    public static final String IDENTIFIER_URI  = "ivo://ivoa.net/vospace/core#identifier";  // an unambiguous reference to the resource within a given context
    public static final String LANGUAGE_URI  = "ivo://ivoa.net/vospace/core#language";    // a language of the resource    
    public static final String LENGTH_URI  = "ivo://ivoa.net/vospace/core#length";      // the length or size of a resource      
    public static final String MODIFICATION_TIME_URI  = "ivo://ivoa.net/vospace/core#mtime";       // the data modification time    
    public static final String PUBLIC_READ_URI  = "ivo://ivoa.net/vospace/core#publicread";  // whether this resource is world readable
    public static final String PUBLISHER_URI  = "ivo://ivoa.net/vospace/core#publisher";   // an entity responsible for making the resource available
    public static final String QUOTA_URI  = "ivo://ivoa.net/vospace/core#quota";       // the value of a system quota on the resource   
    public static final String RELATED_RESOURCE_URI  = "ivo://ivoa.net/vospace/core#relation";    // a related resource    
    public static final String RIGHTS_ON_URI  = "ivo://ivoa.net/vospace/core#rights";      // information about rights held in and over the resource
    public static final String RESOURCE_RELATED_URI  = "ivo://ivoa.net/vospace/core#source";      // a related resource from which the described resource is derived
    public static final String SUBJECT_URI  = "ivo://ivoa.net/vospace/core#subject";     // the topic of the resource     
    public static final String TITLE_URI  = "ivo://ivoa.net/vospace/core#title";       // a name given to the resource  
    public static final String TYPE_URI  = "ivo://ivoa.net/vospace/core#type";        // the nature or genre of the resource
    //
    // Non-standard properties
    public static final String ASYNC_TRANS_URN = "urn:async_trans";
    public static final String STICKY_URN = "urn:sticky";
    
    

    
    public static String getStandardNodePropertyByName(Node node, String propertyName) {
        return getNodePropertyByURI(node, BASE_URI.concat(propertyName));
    }


    public static String getProperty(Node node, String propertyName) {

        for (Property property : node.getProperties()) {
            if (property.getUri().equals(BASE_URI.concat(propertyName))) {
                return property.getValue();
            }
        }
        return null;
    }
    

    public static String getNodePropertyByURI(Node node, String uri) {
        
        for (Property property : node.getProperties()) {
            if (uri.equals(property.getUri())) {
                return property.getValue();
            }
        }
        return null;
        
    }
    // Returns all properties stored inside the node under the requested
    // property URI.    
    public static List<String> getNodePropertyAsListByURI(Node node, String propertyURI) {

        List<String> propertyList = node.getProperties().stream()
                .filter((i) -> i.getUri()
                .equals(propertyURI))
                .map((i) -> i.getValue())
                .collect(Collectors.toList());

        return propertyList;
    }

    public static List<String> parsePropertyStringToList(String property) {
        // If separator changes, this method should remain consistent
        // For now it assumes that " " is the separator        
        String separator = " ";

        String trimmedProperty = property.trim();
        if (trimmedProperty.isEmpty()) {
            return List.of();
        }

        return List.of(trimmedProperty.split(separator));

    }
    
}
