package net.ivoa.xml.vospace.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.inaf.oats.vospace.datamodel.NodeProperties;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.bind.JAXB;
import static org.junit.jupiter.api.Assertions.assertEquals;
import org.junit.jupiter.api.Test;

public class TransferTest {

    private static final ObjectMapper MAPPER = new ObjectMapper();

    private static final String URI_PREFIX = "vos://example.com!vospace";

    @Test
    public void testXmlSerialization() throws Exception {

        Transfer transfer = getTransfer();

        String xml;
        try ( StringWriter sw = new StringWriter()) {
            JAXB.marshal(transfer, sw);
            xml = sw.toString();
            System.out.println(xml);
        }

        Transfer deserialized;
        try ( StringReader sr = new StringReader(xml)) {
            deserialized = JAXB.unmarshal(sr, Transfer.class);
        }

        verifyTransfersAreEquals(transfer, deserialized);
    }

    private Transfer getTransfer() {
        Transfer transfer = new Transfer();

        transfer.setTarget(URI_PREFIX + "/mynode");
        transfer.setDirection("pullFromVoSpace");        

        Protocol protocol = new Protocol();
        protocol.setUri("ivo://ivoa.net/vospace/core#httpget");
        protocol.setEndpoint("http://ia2.inaf.it/data?param1=value1&param2=value2");

        transfer.getProtocols().add(protocol);
        
        Param groupWriteParam = new Param();
        groupWriteParam.setUri(NodeProperties.GROUP_WRITE_URI);
        groupWriteParam.setValue("group1 group2");
        
        transfer.getParam().add(groupWriteParam);

        return transfer;
    }

    private void verifyTransfersAreEquals(Transfer serialized, Transfer deserialized) {

        assertEquals(serialized.getTarget(), deserialized.getTarget());
        assertEquals(serialized.getDirection(), deserialized.getDirection());
        assertEquals(serialized.getProtocols().size(), deserialized.getProtocols().size());
        assertEquals(serialized.getParam().size(), deserialized.getParam().size());
        assertEquals(serialized.getProtocols().get(0).getEndpoint(), deserialized.getProtocols().get(0).getEndpoint());
        assertEquals(serialized.getParam().get(0).getUri(), deserialized.getParam().get(0).getUri());
        assertEquals(serialized.getParam().get(0).getValue(), deserialized.getParam().get(0).getValue());
    }
}
