package it.inaf.oats.vospace.datamodel;

import java.util.List;
import net.ivoa.xml.vospace.v2.DataNode;
import net.ivoa.xml.vospace.v2.Node;
import net.ivoa.xml.vospace.v2.Property;
import static org.junit.jupiter.api.Assertions.assertEquals;
import org.junit.jupiter.api.Test;

public class NodePropertiesTest {

    @Test
    public void testGetNodePropertyAsListByURI() {

        Property groupRead = new Property();
        groupRead.setUri(NodeProperties.GROUP_READ_URI);
        groupRead.setValue("group1 group2");

        Node node = new DataNode();
        node.getProperties().add(groupRead);
        
        List<String> values = NodeProperties.getNodePropertyAsListByURI(node, NodeProperties.GROUP_READ_URI);

        assertEquals(2, values.size());
        assertEquals("group1", values.get(0));
        assertEquals("group2", values.get(1));
    }
}
