# VOSpace Data Model

## Generating beans from XML schema

    cd xsd
    xjc vospace.xsd

### Changes to the online XSD files

It seems that xjc does something wrong when retriving the imported XSD from the web, so the dependent files have been downloaded and relative path has been specified in `schemaLocation` attribute.

In vospace.xsd:

    <xsd:import namespace="http://www.ivoa.net/xml/UWS/v1.0" schemaLocation="./uws.xsd"/>

In uws.xsd:

    <xs:import namespace="http://www.w3.org/1999/xlink" schemaLocation="./xlink.xsd"/>

### Changes to the generated classes

In package-info.java the following element has been added to serialize the XML keeping the namespace.

    xmlns = {
        @javax.xml.bind.annotation.XmlNs(
                namespaceURI = "http://www.ivoa.net/xml/VOSpace/v2.0",
                prefix = "vos"
        )
    }

Some issues emerged in handling inheritance and namespaces in a way compatible both to JSON and XML formats. Moreover it was necessary to setup a workaround for filling the `xsi:type` of the root node:

In Node.java type field and removeType() method have been added:

    // Used for generating missing type attribute for root node. For child nodes it is filled automatically.
    @XmlAttribute(name = "type", namespace = "http://www.w3.org/2001/XMLSchema-instance", required = false)
    private String type;

    /* This method exists to fix the issue with type attribute. See RemoveDuplicateTypeAdapter class. */
    public void removeType() {
        this.type = null;
    }

For JSON compatibility the following has been added to Node.java (annotation on class):

    @JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "type", include = JsonTypeInfo.As.EXISTING_PROPERTY)
    @JsonTypeIdResolver(NodeTypeJsonResolver.class)

The `@JsonTypeInfo` tells to Jackson that the field type is used to handle inheritance. A custom type id resolver has been created to handle the `vos:` prefix.

2 annotations have been added to each node subtype:

    @XmlRootElement(name = "node")

`@XmlRootElement` is necessary to parse single nodes. The value `"node"` has been specified because by default the bean would be serialized as `<unstructuredDataNode>`.
