package net.ivoa.xml.uws.v1;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.bind.JAXB;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;
import org.junit.jupiter.api.Test;

public class ShortJobDescriptionTest {

    @Test
    public void testXmlSerialization() throws Exception {

        ShortJobDescription jobDesc = getShortJobDescription();

        String xml;
        try ( StringWriter sw = new StringWriter()) {
            JAXB.marshal(jobDesc, sw);
            xml = sw.toString();
            System.out.println(xml);
        }

        assertTrue(xml.contains("xlink:type=\"type\""));

        try ( StringReader sr = new StringReader(xml)) {
            ShortJobDescription deserialized = JAXB.unmarshal(sr, ShortJobDescription.class);
            verifyJobsAreEquals(deserialized);
        }
    }

    private ShortJobDescription getShortJobDescription() {

        ShortJobDescription jobDesc = new ShortJobDescription();
        jobDesc.setCreationTime(getXmlDate("2015-05-26T11:06:45.713"));
        jobDesc.setId("job_id");
        jobDesc.setPhase(ExecutionPhase.EXECUTING);
        jobDesc.setHref("href");
        jobDesc.setOwnerId("owner_id");
        jobDesc.setRunId("run_id");
        jobDesc.setType("type");

        return jobDesc;
    }

    private XMLGregorianCalendar getXmlDate(String dateTimeString) {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(dateTimeString);
        } catch (DatatypeConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void verifyJobsAreEquals(ShortJobDescription deserialized) {

        assertEquals("href", deserialized.getHref());
        assertEquals("job_id", deserialized.getId());
        assertEquals("owner_id", deserialized.getOwnerId());
        assertEquals("run_id", deserialized.getRunId());
        assertEquals("type", deserialized.getType());
        assertEquals("href", deserialized.getHref());
        assertEquals("2015-05-26T11:06:45.713", deserialized.getCreationTime().toString());
        assertEquals(ExecutionPhase.EXECUTING, deserialized.getPhase());
    }
}
