/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package it.inaf.oats.vospace.datamodel;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import net.ivoa.xml.vospace.v2.Node;


public class NodeUtils {
 
    
    
    /**
     * Slash is a special character in defining REST endpoints and trying to
     * define a PathVariable containing slashes doesn't work, so the endpoint
     * has been defined using "/nodes/**" instead of "/nodes/{path}" and the
     * path is extracted manually parsing the request URL.
     */
    public static String getPathFromRequestURLString(String requestUrlString ) {
        
        String[] split = requestUrlString.split("/nodes/");

        String path = "/";
        if (split.length == 2) {
            path += split[1];
        }
        return path;
    }
    
    // This method assumes that URL is in the format /node1/node2/...
    // multiple slashes as a single separator are allowed
    // But the output has only single slash separators
    public static String getParentPath(String path) {

        String[] parsedPath = path.split("[/]+");

        if (parsedPath.length < 2 || !parsedPath[0].isEmpty()) {
            throw new IllegalArgumentException();
        }

        StringBuilder sb = new StringBuilder();
        sb.append("/");

        for (int i = 1; i < parsedPath.length - 1; i++) {
            sb.append(parsedPath[i]);
            if (i < parsedPath.length - 2) {
                sb.append("/");
            }
        }

        return sb.toString();
    }
    
    
    public static List<String> subPathComponents(String path) {
        
        List resultList = new ArrayList<String>();
        
        String[] pathComponents = path.split("[/]+");
        
        if (pathComponents.length == 0) { 
                       
            // Manage root node
            resultList.add("/");
            
        } else {
            
            // Manage all precursors in full path
            String parentPath="/";
            for (int i = 1; i < pathComponents.length; i++) { 
                parentPath = parentPath + pathComponents[i] + "/";
                // "I'm managing path = " + parentPath.substring(0, parentPath.length()-1));
                resultList.add(parentPath.substring(0, parentPath.length()-1));
                            
            }
                    
        }
        
        return resultList;
        
    }
    
    public static boolean checkIfWritable(Node myNode, String userName, List<String> userGroups) {
        
        // First check if parent node creator is == userid
        List<String> nodeOwner
                = NodeProperties.getNodePropertyByURI(myNode, NodeProperties.CREATOR_URI);
                        
        
        if (nodeOwner == null
                || nodeOwner.isEmpty()
                || !nodeOwner.get(0).equals(userName)) {
            // Node owner check has failed: let's check if user can write
            // due to group privileges

            // If the user doesn't belong to any groups throw exception
            if (userGroups == null || userGroups.isEmpty()) {
                return false;
            }

            List<String> groupWritePropValues
                    = NodeProperties.getNodePropertyByURI(myNode,
                            NodeProperties.GROUP_WRITE_URI);

            // If groupwrite property is absent in Parent Node throw exception
            if (groupWritePropValues == null
                    || groupWritePropValues.isEmpty()) {
                return false;                
            }

            List<String> nodeGroups
                    = NodeProperties.parsePropertyStringToList(groupWritePropValues.get(0));

            if (nodeGroups.isEmpty()
                    || !nodeGroups.stream()
                            .anyMatch((i) -> userGroups.contains(i))) {
                return false;
            }

        }

        return true;
    }
    
}
