!-----------------------------------------------------------------------------
!
!
                         SUBROUTINE upd_vel
!
!
!-----------------------------------------------------------------------------
!
!
!     Subroutine to advance the velocities of the bodies for a
!     timestep dtime.
!
!
!-----------------------------------------------------------------------------
	 
	 USE fly_h 
        implicit none 
 
!   Declaration of local variables.
!   -------------------------------
        
	INTEGER :: p,k
	REAL(KIND=8) :: tn2,a_dot
!-----------------------------------------------------------------------------
!-----------------------------------------------------------------------------
!   Loop over all velocity components for all bodies.
!-----------------------------------------------------------------------------
!
!
      tn2=tnow+dtime2
      ap=f_ap/tn2
      a_dot = (om_sum+Omega_l*(tn2**three_o_alpha))
      bp = 1./(alpha2*(hubble*hubble)*a_dot*(tn2**2.))


!$OMP PARALLEL PRIVATE(k,p)  
 
!$OMP  DO
       DO p=1,nb_res_loc(me+1)
        DO  k=1,ndim
              vel(k,p)=vel(k,p)*(1.-ap*dtime)/                          &
          (1.+ap*dtime) + acc(k,p)*bp*dtime/(1.+ap*dtime)
!               vel(k,p)=vel(k,p) + acc(k,p)*dtime ! Newtonian velocity update
           ENDDO
        ENDDO
!$OMP END DO
!$OMP END PARALLEL           
        
        
        RETURN
        END
