!-----------------------------------------------------------------------------
!
!
                          SUBROUTINE upd_pos
!
!
!-----------------------------------------------------------------------------
!
!
!     Subroutine to advance the positions of the bodies for a
!     timestep dtime.
!
!-----------------------------------------------------------------------------

	 USE fly_h 
	implicit none
!   Declaration of local variables.
!   -------------------------------
        
	INTEGER :: p,k
        REAL(KIND=8) :: rsize4,delta_step

!-----------------------------------------------------------------------------
!
	rsize4=rsize/4.

!-----------------------------------------------------------------------------
!   Loop over all spatial coordinates for all bodies.
!-----------------------------------------------------------------------------
       
!$OMP PARALLEL PRIVATE(k,p, delta_step)  
 
!$OMP  DO
       DO p=1,nb_res_loc(me+1)
          DO k=1,ndim
	      
	      delta_step=vel(k,p)*dtime
	      
	      IF(ABS(delta_step).ge.rsize4) THEN
	      
  		   
	         write(uterm,*)'SEVERE WARNING Delta_step =',delta_step,       &
               ' Possible numerical instability pos(',k,',',p+idisp,') =',pos(k,p)

	       		
	         call flush(uterm)     

     	       ENDIF
	      IF(ABS(delta_step).eq.0) THEN
	      
  		   
	         write(uterm,*)'SEVERE WARNING Delta_step =',delta_step,' dtime=',dtime,     &
                  'vel(',k,',',p,')=',vel(k,p)

	       		
	         call flush(uterm)     

     	       ENDIF

              pos(k,p)=pos(k,p)+delta_step

	      IF(pos(k,p).lt.rmin(k)) THEN
		 
		 pos(k,p)=pos(k,p)+rsize
              ENDIF
	      
	      IF(pos(k,p).ge.rmin(k)+rsize) THEN
	 	 pos(k,p)=pos(k,p)-rsize
	      ENDIF
           
	   ENDDO
        ENDDO
!$OMP END DO        
!$OMP END PARALLEL           

!   Update position time, system time.
!   ----------------------------------

        tpos=tpos+dtime
        tnow=tpos
	znow=1./(tnow**(1./alpha))-1.
	
	RETURN
        END
